/*
* Creation date : 
* Last modified : %modify_time%
*/
/** @file
* \brief This file contains implementation of 
*  different functions. 
*
* \version CE2_error.c#1:csrc:1
* \author Alexander Masiuk
* \remarks Copyright (C) 2007 by Discretix Technologies Ltd.
* All Rights reserved
*/

/************************ Include Files ***********************/

#include "CE2_error.h"
#include "LLF_error.h"

/************************ Defines *****************************/
/************************ Enums *******************************/
/************************ Typedefs ****************************/
/************************ Global Data *************************/
/************************ Private function prototype **********/
/************************ Private Functions *******************/
/************************ Public Functions ********************/

/**
****************************************************************
* Function Name: 
* CE2_GetErrorDescription
*
*  @param error [in] - error code that is used to retrieve error
*                      description.
*
* @returns \b
*  DxUint8_t* - pointer to the specified error description string.
*
* \brief \b 
* Description:
*  This function returns error description using error code.
*
*  \b 
* Algorithm:
*  -# Verify input parameters for validity;
*  -# Call low level function LLF_GetErrorDescription 
*     to get error string by error code.
***************************************************************/
CE2CIMPORT_C DxUint8_t* CE2_GetErrorDescription(CE2Error_t error /* in */)
{
	return LLF_GetErrorDescription(error);
} /* End of CE2_GetErrorDescription */
